import numpy as np


def apodization(interferogram, position_axis, apodization_width):


    index = np.argmin(abs(position_axis))
    left_pos_axis = position_axis[0:index+1]
    right_pos_axis = position_axis[index+1:]

    left_gauss = np.exp(-(np.power(left_pos_axis, 2))/(2*(np.power(left_pos_axis[0]*apodization_width*2, 2))))
    right_gauss = np.exp(-(np.power(right_pos_axis, 2))/(2*(np.power(right_pos_axis[-1]*apodization_width*2, 2))))

    apodization_window = np.concatenate((left_gauss, right_gauss))

    apodized_interferogram = interferogram * apodization_window
    return apodized_interferogram


def normalize(a):
    b = (a-min(a))/(max(a)-min(a))
    return b
